<?php
// -----
// Part of the "Image Handler" plugin, v5.0.0 and later, by Cindy Merkin a.k.a. lat9 (cindy@vinosdefrutastropicales.com)
// Copyright (c) 2017-2022 Vinos de Frutas Tropicales
//
// This is not a "traditional" Zen Cart language file.  Its purpose is to provide the information associated with
// the admin's Tools->Image Handler's "About/Help" link and is included by that module when/if that link is active.
//
?>
<div>
    <h2>目的と目標</h2>
    <p>Image Handler<sup>5</sup>は、Tim Kröger 氏によるオリジナル貢献をもとにしています。</p>
    <p>このプラグインの本質は、商品画像（特に追加画像）の管理を簡素化し、画像の最適化によってページの表示速度を向上させることです。</p>
    <p>IH<sup>5</sup>は、ストアの <code>/bmz_cache</code> フォルダに設定に基づいて生成された商品画像を保存します。<strong>元の画像を置き換えたり変更したりすることはありません</strong>。したがって、既存のストアにも<em>安全に</em>導入可能です。</p>
    <p>このプラグインでは、GDライブラリまたはImageMagick（サーバーにインストールされていれば）を使用して、小・中・大の画像をリクエスト時に即座に生成・リサイズできます。1枚の大きな画像をアップロードするだけでも、必要に応じてサイズ調整されますし、中・大サイズ用に別々の画像を用意することも可能です。透かし画像を重ねて、画像にウォーターマークを付けることもできます。</p>
    <p>このプラグインには強力な管理インターフェースが含まれており、Attribute Managerと同様に商品を一覧し、FTPを使わずに画像の追加・削除・アップロードが可能です。EZ-Populate や Database I/O Manager といった一括更新ツールとも互換性があります。</p>

    <h2>主な機能</h2>
    <ul>
        <li>サイトの表示速度を改善（読み込み・表示の高速化）</li>
        <li>プロフェッショナルな画像表示（階段状のギザギザを排除し滑らかなエッジ）</li>
        <li>各画像サイズごとに好みのファイル形式を選択可能</li>
        <li>画像1枚のアップロードで、小・中・大サイズの画像を自動生成</li>
        <li>既存の画像はそのままで、導入・撤去が容易</li>
        <li>ワンクリックでデータベースをアップグレード、インストールも簡単</li>
        <li>EZ-Populate や Database I/O Manager などの一括更新ツールと連携</li>
        <li>ウォーターマーク機能で画像の盗用防止（所有権の証明）</li>
        <li>画像の背景色を選択可能、透明背景もサポート</li>
        <li>商品に複数画像を割り当てる作業が簡単（属性設定と同様のUI）</li>
    </ul>
    <p>IH<sup>5</sup>は、Zen Cartの標準画像機能と<em>共存</em>し、それを置き換えるものではありません。</p>
    <p>「<strong>設定</strong>」と「<strong>使用方法</strong>」セクションを<strong>必ず全て読んでください</strong>。Image Handler<sup>5</sup>が何を行えるかが明確にわかります。</p>

    <h2>トラブルシューティングの基本</h2>
    <p>まず、カスタムテンプレートが有効か確認してください（管理画面 &gt; ツール &gt; テンプレート選択）。</p>
    <p>Image Handler<sup>5</sup>がインストールされていることを確認してください。<strong>管理画面 &gt; ツール &gt; Image Handler<sup>4</sup> &gt; Admin</strong>。<strong>images</strong> フォルダと <strong>bmz_cache</strong> フォルダのパーミッションは 755 に設定してください（ホスティングによっては777が必要な場合もあります）。</p>
    <p>IH<sup>5</sup>が動作しない・エラーが出る場合：</p>
    <ul>
        <li>すべてのファイルが正しい場所にあるか確認</li>
        <li>すべてのImage Handler<sup>5</sup>ファイルがアップロードされているか確認</li>
        <li>FTPで破損していないか確認</li>
        <li>ファイルマージ時の編集が正しいか確認</li>
        <li><strong>設定と使用方法セクションを再度読む</strong></li>
        <li>JavaScriptの競合がないか（Rev7以降はほぼ解決済）</li>
        <li>画像名に特殊文字を含まないように（例: <b>/ \ : ! @ # $ % ^ &lt; &gt; , [ ] { } &amp; * ( ) + = </b>）</li>
    </ul>

    <h2>Zen Cartと画像管理</h2>
    <p>Image Handler<sup>5</sup>は、Zen Cartの画像管理作業を補助します。置き換えるのではなく、<em>共に機能</em>します。以下のFAQも参考にしてください。</p>
    <ul>
        <li><a href="https://docs.zen-cart.com/user/images/images_howto/" target="_blank">画像準備 - ハウツー</a></li>
        <li><a href="https://docs.zen-cart.com/user/troubleshooting/images_distorted/" target="_blank">画像が歪んだり、ぼやけたりするのはなぜ？</a></li>
    </ul>
    <p>追加画像の仕組みに関するFAQ：</p>
    <ul>
        <li><a href="https://docs.zen-cart.com/user/images/additional_images/#why-do-i-see-images-for-other-products-on-my-product-pages" target="_blank">他の商品画像が表示されるのはなぜ？</a></li>
        <li><a href="https://docs.zen-cart.com/user/images/additional_images/" target="_blank">1つの商品に複数画像を追加する方法</a></li>
    </ul>
    <p>これらのFAQを読むことで、Zen Cartと画像処理の関係が明確になるでしょう。</p>

    <h2>将来の拡張に備えて</h2>
    <p>Image Handler<sup>5</sup>は、大規模サイトにも対応できる強力な機能を持っています。小規模なサイトでは、画像を <code>/images</code> フォルダに入れるだけでよいですが、画像数が増えると命名や管理が困難になります。早い段階から準備しておくことで、後々の作業を大きく減らせます。</p>
    <p>Image Handler を使わない場合、1つの画像につき、小・中・大の3種類を作成し、それぞれを特定のフォルダに命名規則に従って配置する必要があります（例：`widget.jpg`, `widget_MED.jpg`, `widget_LRG.jpg` など）。</p>
    <p>IH<sup>5</sup>があれば、1枚の高品質な大サイズ画像をアップロードするだけで、自動で各サイズを生成・最適化し、ページに応じて出し分けてくれます（元画像は変更されません）。</p>
    <p>フォルダ構成例：</p>

    <p>商品: Blue Widget（画像3枚）<br>
      /images/widgets/blue_widget1.jpg（正面）<br>
      /images/widgets/blue_widget2.jpg（側面）<br>
      /images/widgets/blue_widget3.jpg（背面）</p>

    <p>商品: Red Widget（画像1枚）<br>
      /images/widgets/red_widget.jpg</p>

    <p>商品: Gold Doodad（画像2枚）<br>
      /images/doodads/gold_doodad1.jpg（上面）<br>
      /images/doodads/gold_doodad2.jpg（側面）</p>

    <p>商品: Silver Doodad（画像3枚）<br>
      /images/doodads/silver_doodad1.jpg（全体）<br>
      /images/doodads/silver_doodad2.jpg（ディテール）<br>
      /images/doodads/silver_doodad3.jpg（刻印）</p>

    <p>このようにImage Handler<sup>5</sup>を使えば、数千の画像でも混乱なく管理できます。メイン画像を選択すると、それに付随する追加画像は同じフォルダ内に自動で整理されます。</p>
</div>
